INCLUDE "CONSTANTS"
INCLUDE "GLOBALS"

REMOTE_PROC=9

DATUM_IN AXIS(0)=1
DATUM_IN AXIS(1)=2
DATUM_IN AXIS(2)=3

TABLE(comms_tool,VR(vr_tool))
TABLE(comms_atc,0)

TABLE(table_startingup,0)
TABLE(table_spindlerunning,OFF)
TABLE(table_eventhoming,0)
TABLE(table_movesmade,0)
TABLE(comms_task,0)

TABLE(table_applistening,0)

TABLE(comms_maxspeed,2000)

TABLE(comms_tctoolpos, 0)

RUN "ESTOP",1
RUN "DOOROPEN",2
RUN "KNOBS",3

FOR ax = 0 TO 2

    BASE(ax)
    MERGE=ON
    LIMIT_BUFFERED=64
    CORNER_MODE=2+8


'    DECEL_ANGLE = 30 * (PI/180)
    DECEL_ANGLE = 10 * (PI/180)

'    STOP_ANGLE = 45 * (PI/180)
    STOP_ANGLE = 20 * (PI/180)

    FULL_SP_RADIUS=20

    SCHEDULE_TYPE.6 = 0

    FORCE_SPEED = SPEED
    ENDMOVE_SPEED = SPEED
    LOOKAHEAD_FACTOR = 1.0
    UNITS=16

    IF (ax = 2) THEN
        FS_LIMIT = REP_DIST+100
        RS_LIMIT = -REP_DIST-100
    ENDIF

    AXIS_MODE = 4
NEXT ax

PRINT #0, "Chaning tool"


REPEAT
    WA(100)
UNTIL (TABLE(table_startingup) = 7)

RUN "consumer"

DIM dacoutput AS FLOAT
dacoutput = 0

DIM feedoutput AS FLOAT
feedoutput = 0

DIM feedspeed AS FLOAT
feedspeed = 0

DIM temp AS FLOAT
DIM perminperrev AS FLOAT

DIM islathe AS BOOLEAN
islathe = (VR(vr_machine) = microturnpro) OR (VR(vr_machine) = turn270pro) OR (VR(vr_machine) = turn370pro)

DAC AXIS(0) = 0

IF islathe THEN
    BASE(3)
    ATYPE = 79
    ACCEL = 1000
ENDIF


REPEAT
    WA(100)



    IF TABLE(comms_steppermm) <> gl_stepspermm THEN
        gl_stepspermm = TABLE(comms_steppermm)
        setupaxes(gl_stepspermm)
    ENDIF


    IF ABS(TABLE(table_speedrequest) - TABLE(comms_actualspeed)) > 1 AND TABLE(table_spindlerunning) THEN
        rampupspindle()
    ENDIF

    IF TABLE(comms_speed) <> dacoutput THEN
        dacoutput = TABLE(comms_speed)
        setspindlespeed()
        'TABLE(1, DAC_OUT AXIS(0) )
    ENDIF

    IF (TABLE(comms_feed) <> feedspeed) OR (perminperrev <> TABLE(comms_perminperrev)) THEN
        feedspeed = TABLE(comms_feed)
        setfeedspeed()
    ENDIF
    perminperrev = TABLE(comms_perminperrev)
    TABLE(table_newfeedrequest,0)

    IF TABLE(comms_task) > 0 THEN
        temp = TABLE(comms_task)

        SELECT_CASE temp :
            CASE 7'comms_tool

                toolchange(TABLE(comms_tool))

                '

                TABLE(comms_task,0)
            CASE 18'comms_mcode
                handlemcode() 'MCode
            CASE 72'comms_numaxes
                'Number of axes
                TABLE(comms_task,0)
            CASE 54:
                dothread()
                TABLE(comms_task,0)
            CASE 56:
                dosinglethread()
                TABLE(comms_task,0)
            CASE ELSE
                TABLE(comms_task,0)
        END_CASE

    ENDIF

    IF islathe THEN
        readlathspeed()

        IF IN(input_manualturretindex) THEN
            manualtoolbutton()
        ENDIF
    ENDIF


    IF (TABLE(comms_reset) > 0) THEN
        IF NOT prevwascancelled THEN
            starttime = TIME
            prevwascancelled = TRUE
        ENDIF
        IF TIME - prevwascancelled > 1 THEN
            TABLE(comms_reset,0)
            prevwascancelled = FALSE
        ENDIF
    ENDIF

    checkisidle()
    getposition()
UNTIL FALSE





